function ok=STM32F411_IO_Config(skt,Port,Pin,Mode,OSpeed,OType,PUPD,OD,AF)
%ok=UDP_ARM_IO_Config(Port,Pin,)
%Configure an ARM STM gpio/pin register
%  skt    : The udp skt 
%  Port   : The GPIO port name such as GPIOA or GPIOC 
%  Pin    : The io port pin number - 0 to 15 
%  Mode   : 0=input;1=output;2=alternate function;3=analog
%  OType  : The output type 0=pushpull; 1=opendrain
%  OSpeed : The output speed 0=low;1=medium;2=high;3=vhigh
%  PUPD   : Pin pull-up or down  0= no pullup or down;1=pullup;2=pulldown; 3=?
%  OD     : The pin output state 0 - set output =1 ; 0 - set output =0       
%  AF     : Alternate Function - see device data sheet
%
% e.g. STM32F411_IO_Config(skt,"GPIOA",Pin,3,0,0,0,0,0)
% e.g. STM32F411_IO_Config(skt,Port,Pin,Mode,OSpeed,OType,PUPD,OD,AF)
% e.g. STM32F411_IO_Config(skt,"GPIOC",13,1,0,0,0,0,0)
% e.g. STM32F411_IO_Config(skt,"GPIOC",[13 14],1,0,0,0,0,0)
% UDP_ARM_IO_Set(skt,"GPIOC",13,0)
% Ian Stothers 8-6-2020

%Make sure peripheral clock is on
udp_bit_set(skt,"RCC_AHB1ENR",2^(toupper(Port(end))-'A'));

%Mode
  mode_msk= sum(3*(4.^Pin));
  mode_val=sum(Mode*(4.^Pin)); 
  pname=[Port "_MODER"];
  udp_bit_clear(skt,pname,mode_msk);
  udp_bit_set(skt,pname,mode_val);

 %OType
  otype_msk=sum( 1*(2.^Pin));
  otype_val=sum(OType*(2.^Pin)); 
  pname=[Port "_OTYPER"];
  udp_bit_clear(skt,pname,otype_msk);
  udp_bit_set(skt,pname,otype_val);

%Speed
  sp_msk= sum(3*(4.^Pin));
  sp_val=sum(OSpeed*(4.^Pin)); 
  pname=[Port "_OSPEEDR"];
  udp_bit_clear(skt,pname,sp_msk);
  udp_bit_set(skt,pname,sp_val);

%PUPD
  pupd_msk= sum(3*(4.^Pin));
  pupd_val=sum(PUPD*(4.^Pin)); 
  pname=[Port "_PUPDR"];
  udp_bit_clear(skt,pname,pupd_msk);
  udp_bit_set(skt,pname,pupd_val);

 %OD
  od_msk= sum(1*(2.^Pin));
  od_val=sum(OD.*(2.^Pin)); 
  pname=[Port "_ODR"];
  udp_bit_clear(skt,pname,od_msk);
  udp_bit_set(skt,pname,od_val);
  
%AF
Pinlo=find(Pin<8);
Pinhi=find(Pin>7);
if (min(size(Pinlo))>0)
  af_msk= sum(15*(16.^Pin(Pinlo)));
  af_val=sum(AF*(16.^Pin(Pinlo)));
  pname=[Port "_AFR0"];
  udp_bit_clear(skt,pname,af_msk);
  udp_bit_set(skt,pname,af_val);
end
if (min(size(Pinhi))>0)  
  af_msk=sum( 15*(16.^(Pin(Pinhi)-8)));
  af_val=sum(AF*(16.^(Pin(Pinhi)-8)));
  pname=[Port "_AFR1"];
  udp_bit_clear(skt,pname,af_msk);
  udp_bit_set(skt,pname,af_val);
end
ok=1; % some day put some parameter checking in?